function decodeUplink(e){var o={};try{o.data=Decode(e.fPort,e.bytes)}catch(e){o.errors=[e.message]}return o}function Decode(e,o){var t={};if(0==e||0==o.length)return t;if(handle_generic_messages(e,o,t))return t;var n={value:0};switch(get_protocol_version(o)){case 1:case 2:switch(t.header=decode_header(o,n),t.header.message_type){case"boot":t.boot=decode_boot_msg(o,n);break;case"activated":t.activated=decode_activated_msg(o,n);break;case"deactivated":t.deactivated=decode_deactivated_msg(o,n);break;case"sensor_event":t.sensor_event=decode_sensor_event_msg(o,n);break;case"device_status":t.device_status=decode_device_status_msg(o,n);break;case"sensor_data":t.sensor_data=decode_sensor_data_msg(o,n,t.header.protocol_version);break;default:throw new Error("Invalid message type!")}break;case 3:switch(e){case 1:header=decode_header_v3(o,n),t.boot=decode_boot_msg_v3(o,n),t.boot.protocol_version=header.protocol_version;break;case 2:header=decode_header_v3(o,n),t.device_status=decode_device_status_msg_v3(o,n),t.device_status.protocol_version=header.protocol_version;break;case 3:header=decode_header_v3(o,n),t.sensor_event=decode_sensor_event_msg_v3(o,n),t.sensor_event.protocol_version=header.protocol_version;break;case 4:header=decode_header_v3(o,n),t.sensor_data=decode_sensor_data_msg(o,n,header.protocol_version),t.sensor_data.protocol_version=header.protocol_version;break;case 5:header=decode_header_v3(o,n),t.activated=decode_activated_msg_v3(o,n),t.activated.protocol_version=header.protocol_version;break;case 6:header=decode_header_v3(o,n),t.deactivated=decode_deactivated_msg(o,n),t.deactivated.protocol_version=header.protocol_version;break;case 7:t.config_update_ans=decode_config_update_ans_msg(o,n)}break;default:throw new Error("Unsupported protocol version!")}return t}function DecodeRebootInfo(e,o){var t={value:0};return decode_reboot_info(e,o,t)}function Decoder(e,o){return Decode(o,e)}function DecodeHexString(e,o){return Decode(e,from_hex_string(o))}function decode_header(e,o){var t={},o=decode_uint8(e,o);return t.protocol_version=o>>4,t.message_type=message_type_lookup(15&o),t}function decode_header_v3(e,o){var t={},o=decode_uint8(e,o);return t.protocol_version=o>>4,t}function get_protocol_version(e){var o={value:0};return decode_uint8(e,o)>>4}function decode_config_header(e,o){var t={},o=decode_uint8(e,o);return t.protocol_version=o>>4,t.config_type=config_type_lookup(15&o),t}function from_hex_string(e){if("string"!=typeof e)throw new Error("hex_string must be a string");if(!e.match(/^[0-9A-F]*$/gi))throw new Error("hex_string contain only 0-9, A-F characters");if(!0&e.length)throw new Error("hex_string length must be a multiple of two");var o=[];for(i=0;i<e.length;i+=2){var t=e.slice(i,i+2);o.push(parseInt(t,16))}return o}function pad(e,o){for(e=e.toString();e.length<o;)e="0"+e;return e}function decode_float(e,o){var t=decode_int32(e,o),e=t>>>31==0?1:-1,o=t>>>23&255;return 255==o?8388607&t?NaN:1/0*e:e*(0==o?(8388607&t)<<1:8388607&t|8388608)*Math.pow(2,o-150)}function decode_uint32(e,o){var t=0,n=o.value+3;return t=256*(t=256*(t=256*(t=e[n--])+e[n--])+e[n--])+e[+n],o.value+=4,t}function decode_int32(e,o){var t=0,n=o.value+3;return t=(t=(t=(t=0|e[n--])<<8|e[n--])<<8|e[n--])<<8|e[+n],o.value+=4,t}function decode_uint16(e,o){var t=0,n=o.value+1;return t=256*(t=e[n--])+e[+n],o.value+=2,t}function decode_int16(e,o){var t=0,n=o.value+1;return 128&e[n]&&(t=65535),t=(t=t<<8|e[n--])<<8|e[+n],o.value+=2,t}function decode_uint8(e,o){e=e[o.value];return o.value+=1,e}function decode_int8(e,o){var t=0,n=o.value;return 128&e[n]&&(t=16777215),t=t<<8|e[+n],o.value+=1,t}function decode_device_id(e,o){return decode_uint8(e,o).toString()+"-"+pad(decode_uint32(e,o),10)}function decode_sensor_data_config(e,o,t){config=decode_uint32(e,o);var n={};switch(n.frame_number=255&config,n.sequence_number=config>>8&3,n.axis="",config>>10&3){case 0:n.axis="x";break;case 1:n.axis="y";break;case 2:n.axis="z";break;default:throw new Error("Invalid axis value in sensor data config!")}switch(config>>12&1){case 0:n.unit="velocity";break;case 1:default:n.unit="acceleration"}switch(t){case 1:if(n.scale=4*(config>>13&63),0==n.scale)throw new Error("Invalid config.scale value!");break;case 2:var r=config>>13&15;if(r<1||15<r)throw new Error("Invalid config.scale coefficient value!");var a=(config>>17&3)-2;n.scale=r*Math.pow(10,a);break;default:throw new Error("Unsupported protocol version!")}if(n.start_frequency=config>>>19,n.start_frequency<0||8191<n.start_frequency)throw new Error("Invalid start_frequency value in sensor data config!");if(n.spectral_line_frequency=decode_uint8(e,o),0==n.spectral_line_frequency)throw new Error("Invalid spectral_line_frequency value in sensor data config!");return n}function decode_sensor_data_config_v3(e,o){var t={};t.frame_number=decode_uint8(e,o);var n=decode_uint8(e,o);switch(t.sequence_number=3&n,t.axis="",n>>2&3){case 0:t.axis="x";break;case 1:t.axis="y";break;case 2:t.axis="z";break;default:throw new Error("Invalid axis value in sensor data config!")}switch(n>>4&1){case 0:t.resolution="low_res";var r=1.62762;break;case 1:t.resolution="high_res";r=.8138}switch(n>>5&1){case 0:t.unit="velocity";break;case 1:default:t.unit="acceleration"}if(t.start_frequency=decode_uint16(e,o),8191<t.start_frequency)throw new Error("Invalid start_frequency value in sensor data config!");if(t.spectral_line_frequency=decode_uint8(e,o),0==t.spectral_line_frequency)throw new Error("Invalid spectral_line_frequency value in sensor data config!");return t.scale=data_scale_lookup(decode_uint8(e,o)),{result:t,binToHzFactor:r}}function data_scale_lookup(e){if(127<=e)throw new Error("Invalid scale index in sensor data config!");return[.01,.0108175019990394,.0117018349499221,.0126584622963211,.0136932941195217,.014812723651136,.0160236667707382,.0173336047324401,.0187506303843729,.0202834981666202,.0219416781964925,.0237354147752836,.0256757896779659,.027774790616831,.0300453853020469,.0325016015566801,.0351586139811367,.03803283770244,.0411420297875284,.0445053989471126,.0481437242078435,.0520794832859547,.0563369914554751,.0609425517689466,.0659246175587139,.0713139682227294,.0771438993808804,.0834504285766365,.0902725177948457,.097652314170406,.105635410374919,.114271126290003,.123612813707458,.133718185938731,.144649674370014,.156474814165802,.169266661503788,.183104244918794,.198073053544165,.214265565266983,.231781818060089,.250730028020599,.271227257933203,.293400140488639,.317385660625428,.3433320018282,.371399461611073,.401761441841993,.434605520026269,.470134608167771,.508568206367245,.550143758902554,.59511812116874,.64376914654074,.696397402962432,.753328029867193,.814912746902074,.881532026865585,.953597446283568,1.03155422814513,1.11588399250775,1.20710773196486,1.30578903035857,1.41253754462275,1.52801277126748,1.65292812077436,1.78805532507451,1.93422920533864,2.09235282953511,2.26340309161917,2.44843674682223,2.64859694032709,2.86512026966378,3.09934442445761,3.35271645072817,3.62680169079642,3.92329345403096,4.24402347817979,4.59097324591799,4.96628622652541,5.37228111832403,5.81146617368716,6.28655469512105,6.80048179815422,7.35642254459641,7.95781155819499,8.60836424387529,9.31209974165798,10.0733657570639,10.8968654214094,11.7876863479359,12.7513320632845,13.7937560084995,14.9213983196205,16.1412256150957,17.4607740358243,18.8881958037304,20.4323095865101,22.1026549797064,23.9095514427051,25.8641620527597,27.9785624709206,30.2658155459431,32.7400520170796,35.4165578143412,38.3118684955729,41.4438714037792,44.8319161758313,48.496934285282,52.4615683578319,56.7503120583586,61.3896614137401,66.4082785063484,71.8371685495186,77.7098714389746,84.0626689636199,90.9348089558542,98.3687477662216,106.41041256041,115.109485059084,124.519708473503,134.699219533192,145.710907656935,157.622803486073,170.508499180478,184.447603073803,199.526231496888][e]}function decode_reboot_info(e,o,t){var n,r=[0,0,0,0,0,0,0,0];switch(r[0]+=decode_uint8(o,t),r[1]+=decode_uint8(o,t),r[2]+=decode_uint8(o,t),r[3]+=decode_uint8(o,t),r[4]+=decode_uint8(o,t),r[5]+=decode_uint8(o,t),r[6]+=decode_uint8(o,t),r[7]+=decode_uint8(o,t),e){case 0:n="none";break;case 1:n="power cycle";break;case 2:n="swdog ("+String.fromCharCode(r[0],r[1],r[2],r[3]).replace(/[^\x20-\x7E]/g,"")+")";break;case 3:var a={value:4};actualValue=decode_int32(r,a),n="assert (caller: 0x"+uint8_to_hex(r[3])+uint8_to_hex(r[2])+uint8_to_hex(r[1])+uint8_to_hex(r[0])+"; value: "+actualValue.toString()+")";break;case 4:n="application (0x"+uint8_to_hex(r[3])+uint8_to_hex(r[2])+uint8_to_hex(r[1])+uint8_to_hex(r[0])+")";break;case 5:n="system (error: 0x"+uint8_to_hex(r[3])+uint8_to_hex(r[2])+uint8_to_hex(r[1])+uint8_to_hex(r[0])+"; caller: 0x"+uint8_to_hex(r[7])+uint8_to_hex(r[6])+uint8_to_hex(r[5])+uint8_to_hex(r[4])+")";break;default:n="unknown (0x"+uint8_to_hex(r[0])+", 0x"+uint8_to_hex(r[1])+", 0x"+uint8_to_hex(r[2])+", 0x"+uint8_to_hex(r[3])+", 0x"+uint8_to_hex(r[4])+", 0x"+uint8_to_hex(r[5])+", 0x"+uint8_to_hex(r[6])+", 0x"+uint8_to_hex(r[7])+")"}return n}function decode_battery_voltage(e,o){return decode_uint8(e,o)*(2/255)+2}function uint8_to_hex(e){return("0"+Number(e).toString(16).toUpperCase()).slice(-2)}function uint16_to_hex(e){return("000"+Number(e).toString(16).toUpperCase()).slice(-4)}function uint32_to_hex(e){return("0000000"+Number(e).toString(16).toUpperCase()).slice(-8)}function message_type_lookup(e){return type_names=["boot","activated","deactivated","sensor_event","device_status","base_configuration","sensor_configuration","sensor_data_configuration","sensor_data"],e<type_names.length?type_names[e]:"unknown"}function config_type_lookup(e){return type_names=["base","region","reserved","sensor","sensor_data","sensor_conditions"],e<type_names.length?type_names[e]:"unknown"}function device_types_lookup(e){return type_names=["","ts","vs-qt","vs-mt","tt","ld","vb"],e<type_names.length?type_names[e]:"unknown"}function trigger_lookup(e){switch(e){case 0:return"timer";case 1:return"button";case 2:return"condition_0";case 3:return"condition_1";case 4:return"condition_2";case 5:return"condition_3";case 6:return"condition_4";case 7:return"condition_5";default:return"unknown"}}function rssi_lookup(e){switch(e){case 0:return"0..-79";case 1:return"-80..-99";case 2:return"-100..-129";case 3:return"<-129";default:return"unknown"}}function reboot_lookup_major(e){switch(major_reboot_reason=15&e,major_reboot_reason){case 0:return"none";case 1:return"config update";case 2:return"firmware update";case 3:return"button reset";case 4:return"power";case 5:return"communication failure";default:return"system failure"}}function reboot_lookup_minor(e){switch(major_reboot_reason=15&e,minor_reboot_reason=e>>4&15,major_reboot_reason){case 0:case 1:return"";case 2:switch(minor_reboot_reason){case 0:return"success";case 1:return"rejected";case 2:return"error";case 3:return"in progress";default:return"unknown"}case 3:return"";case 4:switch(minor_reboot_reason){case 0:return"black out";case 1:return"brown out";case 2:return"power safe state";default:return"unknown"}case 5:case 6:return"";default:return"unknown"}}function lookup_selection(e){switch(e){case 0:return"extended";case 1:return"min_only";case 2:return"max_only";case 3:return"avg_only";default:return"unknown"}}function deactivation_reason_lookup(e){switch(e){case 0:return"user_triggered";case 1:return"activation_user_timeout";case 2:return"activation_sensor_comm_fail";case 3:return"activation_sensor_meas_fail";default:return"unknown"}}function decode_boot_msg(e,o){var t={};if(46!=e.length)throw new Error("Invalid boot message length "+e.length+" instead of 46");t.base={};var n=decode_uint8(e,o);t.base.device_type=device_types_lookup(n);var r=decode_uint32(e,o);t.base.version_hash="0x"+uint32_to_hex(r);var a=decode_uint16(e,o);t.base.config_crc="0x"+uint16_to_hex(a);var c=decode_uint8(e,o);t.base.reset_flags="0x"+uint8_to_hex(c),t.base.reboot_counter=decode_uint8(e,o),base_reboot_type=decode_uint8(e,o),t.base.reboot_info=decode_reboot_info(base_reboot_type,e,o);var i=decode_uint8(e,o);t.base.bist="0x"+uint8_to_hex(i),t.sensor={};n=decode_uint8(e,o);t.sensor.device_type=device_types_lookup(n),t.sensor.device_id=decode_device_id(e,o);r=decode_uint32(e,o);t.sensor.version_hash="0x"+uint32_to_hex(r);a=decode_uint16(e,o);t.sensor.config_crc="0x"+uint16_to_hex(a);a=decode_uint16(e,o);t.sensor.data_config_crc="0x"+uint16_to_hex(a);c=decode_uint8(e,o);t.sensor.reset_flags="0x"+uint8_to_hex(c),t.sensor.reboot_counter=decode_uint8(e,o),sensor_reboot_type=decode_uint8(e,o),t.sensor.reboot_info=decode_reboot_info(sensor_reboot_type,e,o);i=decode_uint8(e,o);return t.sensor.bist="0x"+uint8_to_hex(i),t}function decode_boot_msg_v3(e,o){if(3!=e.length&&35!=e.length)throw new Error("Invalid boot message length "+e.length+" instead of 3 or 35");var t={base:{},sensor:{}};if(base_reboot_reason=decode_uint8(e,o),t.base.reboot_reason={},t.base.reboot_reason.major=reboot_lookup_major(base_reboot_reason),t.base.reboot_reason.minor=reboot_lookup_minor(base_reboot_reason),sensor_reboot_reason=decode_uint8(e,o),t.sensor.reboot_reason={},t.sensor.reboot_reason.major=reboot_lookup_major(sensor_reboot_reason),t.sensor.reboot_reason.minor=reboot_lookup_minor(sensor_reboot_reason),35==e.length){t.debug="0x";for(var n=o.value;n<e.length;n++)t.debug=t.debug+uint8_to_hex(e[n])}return t}function decode_activated_msg(e,o){var t={};if(7!=e.length)throw new Error("Invalid activated message length "+e.length+" instead of 7");t.sensor={};var n=decode_uint8(e,o);return t.sensor.device_type=device_types_lookup(n),t.sensor.device_id=decode_device_id(e,o),t}function decode_activated_msg_v3(e,o){var t={};if(8!=e.length)throw new Error("Invalid activated message length "+e.length+" instead of 8");t.sensor={};var n=decode_uint8(e,o);return t.sensor.device_type=device_types_lookup(n),t.sensor.device_id=decode_device_id(e,o),t.base={},n=decode_uint8(e,o),t.base.device_type=device_types_lookup(n),t}function decode_deactivated_msg(e,o){var t={};if(3!=e.length)throw new Error("Invalid deactivated message length "+e.length+" instead of 3");var n=decode_uint8(e,o);if(t.reason=deactivation_reason_lookup(n),0!=decode_uint8(e,o))throw new Error("Unsupported deactivated reason length");return t}function decode_sensor_event_msg(e,o){var t={};if(45!=e.length)throw new Error("Invalid sensor_event message length "+e.length+" instead of 45");trigger=decode_uint8(e,o),t.trigger=trigger_lookup(trigger),t.rms_velocity={},t.rms_velocity.x={},t.rms_velocity.x.min=decode_uint16(e,o)/100,t.rms_velocity.x.max=decode_uint16(e,o)/100,t.rms_velocity.x.avg=decode_uint16(e,o)/100,t.rms_velocity.y={},t.rms_velocity.y.min=decode_uint16(e,o)/100,t.rms_velocity.y.max=decode_uint16(e,o)/100,t.rms_velocity.y.avg=decode_uint16(e,o)/100,t.rms_velocity.z={},t.rms_velocity.z.min=decode_uint16(e,o)/100,t.rms_velocity.z.max=decode_uint16(e,o)/100,t.rms_velocity.z.avg=decode_uint16(e,o)/100,t.acceleration={},t.acceleration.x={},t.acceleration.x.min=decode_int16(e,o)/100,t.acceleration.x.max=decode_int16(e,o)/100,t.acceleration.x.avg=decode_int16(e,o)/100,t.acceleration.y={},t.acceleration.y.min=decode_int16(e,o)/100,t.acceleration.y.max=decode_int16(e,o)/100,t.acceleration.y.avg=decode_int16(e,o)/100,t.acceleration.z={},t.acceleration.z.min=decode_int16(e,o)/100,t.acceleration.z.max=decode_int16(e,o)/100,t.acceleration.z.avg=decode_int16(e,o)/100,t.temperature={},t.temperature.min=decode_int16(e,o)/100,t.temperature.max=decode_int16(e,o)/100,t.temperature.avg=decode_int16(e,o)/100;o=decode_uint8(e,o);return t.condition_0=1&o,t.condition_1=o>>1&1,t.condition_2=o>>2&1,t.condition_3=o>>3&1,t.condition_4=o>>4&1,t.condition_5=o>>5&1,t}function decode_sensor_event_msg_v3(e,o){if(11==e.length)return decode_sensor_event_msg_normal(e,o);if(45==e.length)return decode_sensor_event_msg_extended(e,o);throw new Error("Invalid sensor_event message length "+e.length+" instead of 11 or 45")}function decode_sensor_event_msg_normal(e,o){var t={};if(selection=decode_uint8(e,o),t.selection=lookup_selection(selection),"extended"==t.selection)throw new Error("Mismatch between extended bit flag and message length!");var n=decode_uint8(e,o);if(t.condition_0=1&n,t.condition_1=n>>1&1,t.condition_2=n>>2&1,t.condition_3=n>>3&1,t.condition_4=n>>4&1,t.trigger=lookup_trigger(n>>6&3),t.rms_velocity={},x=decode_uint16(e,o)/100,y=decode_uint16(e,o)/100,z=decode_uint16(e,o)/100,temperature=decode_int16(e,o)/100,"min_only"==t.selection)t.rms_velocity={x:{min:x},y:{min:y},z:{min:z}},t.temperature={min:temperature};else if("max_only"==t.selection)t.rms_velocity={x:{max:x},y:{max:y},z:{max:z}},t.temperature={max:temperature};else{if("avg_only"!=t.selection)throw new Error("Only min, max, or, avg is accepted!");t.rms_velocity={x:{avg:x},y:{avg:y},z:{avg:z}},t.temperature={avg:temperature}}return t}function decode_sensor_event_msg_extended(e,o){var t={};if(selection=decode_uint8(e,o),t.selection=lookup_selection(selection),"extended"!=t.selection)throw new Error("Mismatch between extended bit flag and message length!");var n=decode_uint8(e,o);return t.condition_0=1&n,t.condition_1=n>>1&1,t.condition_2=n>>2&1,t.condition_3=n>>3&1,t.condition_4=n>>4&1,t.trigger=lookup_trigger(n>>6&3),t.rms_velocity={},t.rms_velocity.x={},t.rms_velocity.x.min=decode_velocity_v3(e,o),t.rms_velocity.x.max=decode_velocity_v3(e,o),t.rms_velocity.x.avg=decode_velocity_v3(e,o),t.rms_velocity.y={},t.rms_velocity.y.min=decode_velocity_v3(e,o),t.rms_velocity.y.max=decode_velocity_v3(e,o),t.rms_velocity.y.avg=decode_velocity_v3(e,o),t.rms_velocity.z={},t.rms_velocity.z.min=decode_velocity_v3(e,o),t.rms_velocity.z.max=decode_velocity_v3(e,o),t.rms_velocity.z.avg=decode_velocity_v3(e,o),t.acceleration={},t.acceleration.x={},t.acceleration.x.min=decode_acceleration_v3(e,o),t.acceleration.x.peak=decode_acceleration_v3(e,o),t.acceleration.x.rms=decode_acceleration_v3(e,o),t.acceleration.y={},t.acceleration.y.min=decode_acceleration_v3(e,o),t.acceleration.y.peak=decode_acceleration_v3(e,o),t.acceleration.y.rms=decode_acceleration_v3(e,o),t.acceleration.z={},t.acceleration.z.min=decode_acceleration_v3(e,o),t.acceleration.z.peak=decode_acceleration_v3(e,o),t.acceleration.z.rms=decode_acceleration_v3(e,o),t.temperature={},t.temperature.min=decode_acceleration_v3(e,o),t.temperature.max=decode_acceleration_v3(e,o),t.temperature.avg=decode_acceleration_v3(e,o),t}function decode_velocity_v3(e,o){return decode_uint16(e,o)/100}function decode_acceleration_v3(e,o){return decode_int16(e,o)/100}function decode_temperature_v3(e,o){return decode_int16(e,o)/100}function decode_device_status_msg(e,o){var t={};if(24!=e.length)throw new Error("Invalid device_status message length "+e.length+" instead of 24");t.base={},t.sensor={};var n=decode_uint16(e,o);t.base.config_crc="0x"+uint16_to_hex(n),t.base.battery_voltage={},t.base.battery_voltage.low=decode_uint16(e,o)/1e3,t.base.battery_voltage.high=decode_uint16(e,o)/1e3,t.base.battery_voltage.settle=decode_uint16(e,o)/1e3,t.base.temperature={},t.base.temperature.min=decode_int8(e,o),t.base.temperature.max=decode_int8(e,o),t.base.temperature.avg=decode_int8(e,o),t.base.lvds_error_counter=decode_uint8(e,o),t.base.lora_tx_counter=decode_uint8(e,o),t.base.avg_rssi=-decode_uint8(e,o),t.base.avg_snr=decode_int8(e,o);var r=decode_uint8(e,o);t.base.bist="0x"+uint8_to_hex(r);var a=decode_uint8(e,o);t.sensor.device_type=device_types_lookup(a);n=decode_uint16(e,o);t.sensor.config_crc="0x"+uint16_to_hex(n);n=decode_uint16(e,o);t.sensor.data_config_crc="0x"+uint16_to_hex(n),t.sensor.event_counter=decode_uint8(e,o);r=decode_uint8(e,o);return t.sensor.bist="0x"+uint8_to_hex(r),t}function decode_device_status_msg_v3(e,o){if(9!=e.length&&12!=e.length)throw new Error("Invalid device status message length "+e.length+" instead of 9 or 12");var t={base:{},sensor:{}};t.base.battery_voltage=decode_battery_voltage(e,o),t.base.temperature=decode_int8(e,o),t.base.lora_tx_counter=decode_uint16(e,o),rssi=decode_uint8(e,o),t.base.avg_rssi=rssi_lookup(rssi);var n=decode_uint8(e,o);t.base.bist="0x"+uint8_to_hex(n),t.sensor.event_counter=decode_uint8(e,o);n=decode_uint8(e,o);if(t.sensor.bist="0x"+uint8_to_hex(n),12==e.length){t.debug="0x";for(var r=o.value;r<e.length;r++)t.debug=t.debug+uint8_to_hex(e[r])}return t}function decode_config_update_ans_msg(e,o){if(6!=e.length)throw new Error("Invalid config update ans message length "+e.length+" instead of 6");var t={},t=decode_config_header(e,o);return tag=decode_uint32(e,o),t.tag="0x"+uint32_to_hex(tag),counter=decode_uint8(e,o),t.counter=15&counter,t}function lookup_trigger(e){switch(e){case 0:return"condition change";case 1:return"periodic";case 2:return"button press";default:return"unknown"}}function decode_sensor_data_msg(e,o,t){var n={};if(46!=e.length)throw new Error("Invalid sensor_data message length "+e.length+" instead of 46");var r,a=0;3==t?(r=decode_sensor_data_config_v3(e,o),n.config=r.result,r=r.binToHzFactor,chunk_size=39,data_offset=7):(n.config=decode_sensor_data_config(e,o,t),r=1.62762,chunk_size=40,data_offset=6,"acceleration"==n.config.unit&&(a=Math.min(2,n.config.start_frequency))),n.raw=e.slice(data_offset),n.frequency=[],n.magnitude=[];var c=n.config.spectral_line_frequency*r,_=(n.config.start_frequency-a)*c;for(_+=n.config.frame_number*chunk_size*c,i=0;i<chunk_size;i++)n.frequency[i]=_+i*c,n.magnitude[i]=n.raw[i]*n.config.scale/255;return n}function handle_generic_messages(e,o,t){var n={value:0};if(203!==e)return!1;return 1===decode_uint8(o,n)&&(t.DevVersion={FW_version:"0x"+uint32_to_hex(decode_uint32(o,n)),HW_version:"0x"+uint32_to_hex(decode_uint32(o,n))}),!0}"undefined"!=typeof module&&(module.exports={decodeUplink:decodeUplink,Decode:Decode,Decoder:Decoder,DecodeHexString:DecodeHexString,DecodeRebootInfo:DecodeRebootInfo,decode_float:decode_float,decode_uint32:decode_uint32,decode_int32:decode_int32,decode_uint16:decode_uint16,decode_int16:decode_int16,decode_uint8:decode_uint8,decode_int8:decode_int8,decode_device_id:decode_device_id,decode_reboot_info:decode_reboot_info,decode_battery_voltage:decode_battery_voltage,decode_sensor_data_config:decode_sensor_data_config,decode_sensor_data_config_v3:decode_sensor_data_config_v3,from_hex_string:from_hex_string,decode_velocity_v3:decode_velocity_v3,decode_acceleration_v3:decode_acceleration_v3,decode_temperature_v3:decode_temperature_v3}),Object.prototype.in=function(){for(var e=0;e<arguments.length;e++)if(arguments[e]==this)return!0;return!1};